﻿namespace ProxyDemo
{
    using System;
    using System.Collections;
    using System.Runtime.Remoting;
    using System.Runtime.Remoting.Channels;
    using System.Runtime.Remoting.Proxies;
    using System.Runtime.Remoting.Messaging;
    using BasicServer;

    /// <summary>
    /// Custom Proxy Class.
    /// </summary>
    public class MyRealProxy : RealProxy
    {
        Type myType;

        public MyRealProxy(Type type)
            : base(type)
        {
            myType = type;
        }

        public override IMessage Invoke(IMessage msg)
        {
            Console.WriteLine("IMessage Properties:\n");

            IDictionary myProps = msg.Properties;

            foreach (object key in myProps.Keys)
            {
                Console.WriteLine(
                    "  Key: {0}\n           Value: {1}",
                    key.ToString(), myProps[key]);
            }

            MarshalByRefObject myObject =
             (MarshalByRefObject)Activator.CreateInstance(myType);

            ObjRef myRef = RemotingServices.Marshal(myObject);

            msg.Properties["__Uri"] = myRef.URI;

            IMessage returnMsg =
                ChannelServices.SyncDispatchMessage(msg);

            return returnMsg;
        }
    }

    /// <summary>
    /// Remoting Proxy Client.
    /// </summary>
    class RemotingProxyClient
    {
        static void Main(string[] args)
        {
            Type type = typeof(BasicRemotingServer);

            RemotingConfiguration.Configure(
                "ProxyDemo.exe.config", false);

            MyRealProxy myProxy = new MyRealProxy(type);

            BasicRemotingServer brs =
             (BasicRemotingServer)myProxy.GetTransparentProxy();

            Console.WriteLine("\nServer Response: {0}",
                brs.GetServerResponse());
        }
    }
}
